<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class InviteTable extends Model 
{

    protected $table = 'invites_tables';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('slug', 'invite_id', 'table_id', 'statut');
    protected $visible = array('slug', 'invite_id', 'table_id', 'statut');

    public function table()
    {
        return $this->belongsTo('App\Models\Table', 'table_id');
    }

    public function invite()
    {
        return $this->belongsTo('App\Models\Invite', 'invite_id');
    }

}